/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userprof;

import com.ibm.hwmca.base.userprof.UserAttributes;
import com.ibm.hwmca.base.userprof.UserProfErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;
import java.util.List;

public class AddUserBean
extends PanelBean
implements UserProfErrorIds {
    private ItemDescriptor[] m_idUserTable;
    private ColumnDescriptor[] m_cdUserTableStructure;
    private int[] m_iUserTableSelection;
    private String[] userids;
    private String[] descriptions;
    UserTaskManager _utm;
    List _systemUsers = new ArrayList();
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "com.ibm.hwmca.base.userprof.AddUserBean");
    private static final String TRACE_MASKF = "USRAUBSF";
    private static final String TRACE_MASKT = "USRAUBST";
    private static final String TRACE_MASKD = "USRAUBSD";

    public AddUserBean(List myUsers) {
        Trace.trace(TRACE_MASKT, "-> AddUserBean(list) ");
        this._systemUsers = myUsers;
    }

    public void update(Object updatedObjects) {
        Trace.trace(TRACE_MASKT, "-> AddUserBean.update(object) ");
        this._systemUsers = (List)updatedObjects;
        this.fillUsers();
    }

    public AddUserBean() {
    }

    public ColumnDescriptor[] getUserTableRowStructure() {
        return this.m_cdUserTableStructure;
    }

    public int getUserTableRowStatus() {
        return 3;
    }

    public int getUserTableRowCount() {
        int retCount = 0;
        if (this.m_idUserTable != null) {
            retCount = this.m_idUserTable.length / 2;
        }
        return retCount;
    }

    public ItemDescriptor[] getUserTableRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{new ItemDescriptor(), new ItemDescriptor()};
        rowAt[0] = this.m_idUserTable[index * 2];
        rowAt[1] = this.m_idUserTable[index * 2 + 1];
        return rowAt;
    }

    public void setUserTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idUserTable[index * 2] = items[0];
        this.m_idUserTable[index * 2 + 1] = items[1];
    }

    public int[] getUserTableSelection() {
        return this.m_iUserTableSelection;
    }

    public void setUserTableSelection(int[] selected) throws IllegalUserDataException {
        int i;
        int selectValue = 0;
        if (selected != null) {
            i = 0;
            while (i < selected.length) {
                selectValue = selected[i];
                ++i;
            }
        } else {
            System.out.println("nothing selected ");
        }
        this.m_iUserTableSelection = new int[selected.length];
        i = 0;
        while (i < selected.length) {
            this.m_iUserTableSelection[i] = selected[i];
            selectValue = selected[i];
            ++i;
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void setUTM(UserTaskManager utm) {
        this._utm = utm;
        this.fillUsers();
    }

    public UserTaskManager getUTM() {
        return this._utm;
    }

    public void prepare() {
        this.setUTM(this.userTaskManager);
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> AddUserBean.load() ");
        this.m_idUserTable = new ItemDescriptor[0];
        this.m_cdUserTableStructure = new ColumnDescriptor[0];
        this.m_iUserTableSelection = new int[0];
    }

    public void fillUsers() {
        Trace.trace(TRACE_MASKT, "-> AddUserBean.fillUsers() ");
        int i = 0;
        int tableSize = 0;
        tableSize = this._systemUsers.size();
        this.m_idUserTable = new ItemDescriptor[tableSize * 2];
        this.m_cdUserTableStructure = new ColumnDescriptor[0];
        this.m_iUserTableSelection = new int[1];
        this.m_iUserTableSelection[0] = 0;
        i = 0;
        while (i < tableSize) {
            ItemDescriptor[] newRow = new ItemDescriptor[]{new ItemDescriptor("i" + String.valueOf(i), ((UserAttributes)this._systemUsers.get(i)).getUserid()), new ItemDescriptor("s" + String.valueOf(i), ((UserAttributes)this._systemUsers.get(i)).getDescription().toString())};
            this.setUserTableRowAt(i, newRow);
            ++i;
        }
        int[] myRow = new int[]{0, 0};
        this._utm.refreshElement("UserTable");
        this.setUserTableSelection(myRow);
        Trace.trace(TRACE_MASKT, "<- AddUserBean.fillUsers() ");
    }

    public void panelAction(TaskActionEvent event) {
        Object mySelection = null;
        String actionCommand = event.getActionCommand();
        String command = event.getElementName();
        Object userSelected = null;
        int[] itemSelected = null;
        PanelTaskletRequest request = new PanelTaskletRequest();
        UserTaskManager utm = (UserTaskManager)event.getSource();
        if (utm == null || this.userTaskManager == null) {
            return;
        }
        if (command.equals("userMenu.add")) {
            request.setData("action", "add");
            this.postTaskletRequest(request);
        } else if (actionCommand.equalsIgnoreCase("userMenu.copy")) {
            request.setData("action", "copy");
            itemSelected = this.getUserTableSelection();
            request.setData("index", new Integer(itemSelected[0]));
            this.postTaskletRequest(request);
        } else if (actionCommand.equalsIgnoreCase("userMenu.remove")) {
            request.setData("action", "remove");
            itemSelected = this.getUserTableSelection();
            if (this.isRemoveable(itemSelected[0])) {
                request.setData("index", new Integer(itemSelected[0]));
                this.postTaskletRequest(request);
            }
        } else if (actionCommand.equalsIgnoreCase("userMenu.modify")) {
            request.setData("action", "modify");
            itemSelected = this.getUserTableSelection();
            request.setData("index", new Integer(itemSelected[0]));
            this.postTaskletRequest(request);
        } else if (actionCommand.equalsIgnoreCase("CANCEL")) {
            request.setCanceled();
            this.postTaskletRequest(request);
        } else {
            this.dispose();
        }
    }

    public boolean isRemoveable(int selected) {
        boolean removeable = true;
        UserAttributes badUser = (UserAttributes)this._systemUsers.get(selected);
        Trace.trace(TRACE_MASKT, "-> deleteUserRow() " + badUser.getUserid());
        Trace.trace(TRACE_MASKT, "-> is this user editable? " + badUser.isEditable());
        if (!badUser.isEditable()) {
            removeable = false;
            BaseMessageTitle title = new BaseMessageTitle("ADM9011");
            MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("ADM0021")};
            LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
            try {
                CommonMsgApp.showMessageBox(this.userTaskManager, title, bmt, "ADM0021", MsgType.INFORMATION_MESSAGE, options);
            }
            catch (Exception exc) {
                HException ex = new HException(exc);
                new FrameworkLog(classLogInfo, 1025, ex).log();
            }
        } else {
            try {
                LocalizableText ans = CommonMsgApp.showMessageBox(this.userTaskManager, (LocalizableText)new BaseMessageTitle("ADM9004"), new BaseMessageText("ADM0006"), null, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
                if (ans.equals(CommonMsgInterface.NO_BUTTON)) {
                    removeable = false;
                }
            }
            catch (Exception e) {}
        }
        return removeable;
    }
}

